#!/bin/bash
# ---------------------------------------------------
# Script to create bootable ISO in Linux
# usage: make_iso.sh [ /tmp/porteus.iso ]
# author: Tomas M. <http://www.linux-live.org>
# updated for Porteus by fanthom <http://www.porteus.org>
# ---------------------------------------------------

if [ "$1" = "--help" -o "$1" = "-h" ]; then
  echo "This script will create bootable ISO from files in curent directory."
  echo "Current directory must be writable."
  echo "example: $0 /mnt/sda5/porteus.iso"
  exit
fi

CDLABEL="Porteus"
ISONAME=$(readlink -f "$1")

cd $(dirname $0)

if [ "$ISONAME" = "" ]; then
   SUGGEST=$(readlink -f ../../$(basename $(pwd)).iso)
   echo -ne "Target ISO file name [ Hit enter for $SUGGEST ]: "
   read ISONAME
   if [ "$ISONAME" = "" ]; then ISONAME="$SUGGEST"; fi
fi

mkisofs -o "$ISONAME" -v -l -J -joliet-long -R -D -A "$CDLABEL" \
-V "$CDLABEL" -no-emul-boot -boot-info-table -boot-load-size 4 \
-b boot/syslinux/isolinux.bin -c boot/syslinux/isolinux.boot ../.
